/**
 * TODO: Copyright
 */
package org.eclipse.higgins.framework.idas;

import java.net.URI;

/**
 * As defined at <a href="http://spwiki.editme.com/DigitalSubjectM4">http://spwiki.editme.com/DigitalSubjectM4</a> and <a href="http://spwiki.editme.com/ContextProvider">http://spwiki.editme.com/ContextProvider</a>, This interface holds a set of {@link IDigitalSubject} objects.<p>
 *
 */
public interface IDigitalSubject
{
	/**
	 * Return all attributes of this IDigitalSubject<p>
	 * 
	 * @return An Iterable object for IAttributes.
	 */
	public Iterable<IAttribute> getAttributes();
	
	/**
	 * Return specified attribute of this IDigitalSubject<p>
	 *
	 * @param attrID The identifier of the attribute to be returned.
	 * @return An IAttribute or null if none exits.
	 */
	public IAttribute getAttribute(URI attrID);
	
	/**
	 * Returns the Contextually Unique Identifier of this DigitalSubject
	 * 
	 * @return Contextually Unique Identifier of this DigitalSubject
	 */
	public String getUniqueID();
	
	/**
	 * Retruns the type of this DigitalSubject.<br>
	 * As all DigitalSubjects are required to have a type attribute, this is a shortcut for calling getAttribute("<URI of type attrID>").
	 * @return The type of this DigitalSubject.
	 */
	public String getType();


}
